<?php

class FirmaController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'admin';

	public function init()
	{
		Yii::import('application.modules.administration.controllers.MainController');
		$mainController = new MainController('main');
		$this->menu = $mainController->getMenu();
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
			'postOnly + delete',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated users to perform actions
				'actions'=>array('create','update','delete','admin','formStatusChange','view'),
				'roles'=>array('admin', 'schoolAdmin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$model = Firma::model()->findByAttributes(array('id'=>$id));

		$companiese = Yii::app()->user->getState('companies');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese) && !in_array($model->id, Yii::app()->user->getState('companies')))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$forms = Firma::model()->getForms($id);

		$this->render('view',array(
			'model'=>$model,
			'forms'=>$forms
		));
	}

	public function actionFormStatusChange($userFormId, $status)
	{
		if(!($status == FormularzUzytkownika::STATUS_ACCEPTED || $status == FormularzUzytkownika::STATUS_REFUSED))
			throw new CHttpException(404,'Nie można znaleźć podanej strony.');

		$model = FormularzUzytkownika::model()->findByPk($userFormId);
		$model->status = $status;
		$model->save(false);

		$statusMessage = 'Formularz "'.$model->formularz->nazwa.'" został ';
		$statusMessage .= $model->status==FormularzUzytkownika::STATUS_ACCEPTED?'zaakceptowany.':'odrzucony.';

		Yii::app()->user->setFlash('formStatusChanged',$statusMessage);

		$this->redirect(Yii::app()->request->getUrlReferrer());
	}


	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Firma;
		$schools = Szkola::model()->findAll();
		$user = null;

		if(isset($_GET['userId']))
		{
			$user = Uzytkownik::model()->findByPk($_GET['userId']);
			if($user)
				$model->idKlasy = $user->idKlasy;
		}

		//else
		//	throw new CHttpException(404, 'Wystąpił błąd.');

		if(isset($_POST['Firma']))
		{
			$model->attributes = $_POST['Firma'];
			$model->czasUtworzenia = new CDbExpression('SYSDATE');

			if($model->save())
			{

				$fields = Dziedzina::model()->findAll();

				foreach($fields as $field)
				{
					$companyField = new DziedzinaFirmy();
					$companyField->idFirmy = $model->id;
					$companyField->idDziedziny = $field->id;
					$companyField->save(false);
				}

				if(isset($_GET['userId']))
				{
					if($user) // przy przenoszeniu ucznia do nowej firmy musi on nadrobić od zera.
					{
						$newUser = new Uzytkownik();
						$newUser->attributes = $user->attributes;
						$newUser->id = null;
						$newUser->idFirmy = $model->id;
						$newUser->save(false);

						$user->status = Uzytkownik::USER_STATUS_EXCLUDED;
						$user->email .= '--moved1';

						// nowa firma - nie kopiujemy danych, jedynie zebrane punkty
						$dziedziny = DziedzinaUzytkownika::model()->findAllByAttributes(array('idUzytkownika' => $user->id));
						$dziedzinyFirmy = DziedzinaFirmy::model()->findAllByAttributes(array('idFirmy' => $model->id));
						foreach($dziedziny as $dziedzina)
						{
								$dziedzinaNowa = new DziedzinaUzytkownika();
								$dziedzinaNowa->attributes = $dziedzina->attributes;
								$dziedzinaNowa->idUzytkownika = $newUser->id;
								$dziedzinaNowa->id = null;
								foreach($dziedzinyFirmy as $dzf)
								{
									if($dzf->idDziedziny == $dziedzina->idDziedziny)
									{
										$dzf->punkty += intval($dziedzina->punkty);
										$dzf->save(false);
									}
								}
								$dziedzinaNowa->save(false);
						}

						$user->save(false);
						$this->redirect(array('/administration/uzytkownik/view', 'id'=>$newUser->id));
					}
					else
					{
						$user->idFirmy = $model->id;
						$user->save(false);
						$this->redirect(array('/administration/uzytkownik/view', 'id'=>$user->id));
					}
				}

				$this->redirect(array('admin'));
			}
		}

		$this->render('create', array(
			'model'=>$model,
			'schools'=>$schools
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = Firma::model()->with(array('klasa'))->findByPk($id);

		$companiese = Yii::app()->user->getState('companies');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese) && !in_array($model->id, Yii::app()->user->getState('companies')))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$students = Uzytkownik::model()->findAll('"idFirmy"='.$id.' and "status" not in (2,3)');
		$schools = Szkola::model()->findAll();

		$model->schoolId = $model->klasa->idSzkoly;

		if(isset($_POST['Firma']))
		{
			$model->attributes = $_POST['Firma'];

			if($model->save())
				$this->redirect(array('admin'));
		}

		$this->render('update',array(
			'model'=>$model,
			'students'=>$students,
			'schools'=>$schools,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$model = $this->loadModel($id);

		try
		{
			$model->delete();
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Firma('search');
		$model->unsetAttributes();
		$model->dbCriteria->addCondition(Yii::app()->db->quoteTableName('klasa').'.'.Yii::app()->db->quoteColumnName('czyTestowa').' != 1');

		if(isset($_GET['Firma']))
			$model->attributes = $_GET['Firma'];

		$this->render('admin', array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Firma::model()->findByPk($id);

		if($model === null)
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		$companiese = Yii::app()->user->getState('companies');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese) && !in_array($model->id, Yii::app()->user->getState('companies')))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		return $model;
	}
}
